%
% H08.02
% 
% Find the KKT points for 
% 
%             min x^2 + y^2
%             s.t. y-ax^2+1 = 0 ,
% 
% with a > 0
% 

clear
close 
clc

%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%
%%%%                      Function definitions                              %%%%
%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%

function drawProblem(a)
    % drawProblem(a)
    %
    % Creates a contour plot of the problem
    % 
    % INPUT:
    %   a
    %     scalar
    %     Function parameter
    % OUTPUT:
    %   none
    %
    
    % ...
    % ...
    
end

function [y,dy] = kkt(z,a)
    % [y,dy] = kkt(z,a)
    % 
    % This is the KKT-system of our problem.
    % It takes a variable-vector that consists of the coordinates and the 
    % Lagrange-Multipliers. The function also takes a parameter.
    %
    % INPUT:
    %   z
    %     [3,1]
    %     Variable-vector
    %   a
    %     scalar
    %     Parameter
    % OUTPUT:
    %   y
    %     [3,1]
    %     KKT-equations
    %   dy
    %     [3,3]
    %     Gradient
    % 
    
    x = z(1);
    y = z(2);
    lam = z(3);
      
    % ...
    % ...  
end

function x = newton(fun,x0)     
    % x = newton(fun,x0)     
    % 
    % Newton's method for solving the equation fun(x) = 0
    %
    % In this exercise we need a parameterized function. We can first define the 
    % parameter and pass the objective function to newton in the following way. 
    % The objective function knows the value of a, but within newton() it 
    % appears as a function of only one variable.
    %    a = 1;
    %    z = newton(@(z) kkt(z,a), [1;1;1])
    % 
    % INPUT
    %   fun
    %     function handle: [y,dy] = fun(x)
    %     Objective function
    %   x0 
    %     [n,1]
    %     Initial guess
    % OUTPUT:
    %   x
    %     [n,1]
    %     Solution
    %
    
    % ...
    % Implement newton's method
    % ...
end     

function zUniq = basinsOfAttraction(a)
    % basinsOfAttraction(a)
    % 
    % This function solves the problem kkt(x,a) = 0 for multiple initial 
    % guesses, identifies similar solutions and draws the basins of attraction
    % 
    % INPUT:
    %   a
    %     scalar
    %     Parameter
    % OUTPUT
    %   zUniq
    %     [2,n]
    %     Unique solution vectors. Each column is a unique solution (x,y)
    %
    
    %%% Solve the problem at multiple initial values
    xVals = linspace(-2,2,100);
    yVals = linspace(-2,2,100);
    
    [x,y] = meshgrid(xVals, yVals);
    
    % ...
    % Apply Newton's method for each initial guess.
    % ...
    
    %%% Group unique solutions and assign an id
    
    % ...
    % "id" should be a matrix of the same size as x and y.
    % ...   
    
    %%% Plot the Basins of attraction
    
    imagesc(xVals,yVals,id)
    
    % ... 
    % Edit the plot as you like to make clear what it shows.
    % ...
    
end

%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%
%%%%                            Main script  a)                             %%%%
%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%
a = 0.75;
figure
drawProblem(a)
    
z = newton(@(z) kkt(z,a), [1;1;1])
plot(z(1), z(2), 'bo')

%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%
%%%%                            Main script  b)                             %%%%
%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%

%a = 0.7;
%
%figure
%subplot(2,1,1)
%    zUniq = basinsOfAttraction(a);
%    
%subplot(2,1,2)
%    drawProblem(a)
%    for i = 1:size(zUniq,2)
%        plot(zUniq(1,i), zUniq(2,i), 'ko')
%    end
    
    
